<?php
/**
 * ----------------------------------------------------
 * Process Pinjaman Koperasi
 * ----------------------------------------------------
 */

require_once '../config/config.php';
require_once '../config/database.php';
require_once '../config/auth.php';

$aksi = $_POST['aksi'] ?? null;
$id   = $_POST['id'] ?? null;

if (!$aksi || !$id) {
    die('Aksi tidak valid');
}

// Ambil data pinjaman
$stmt = $db->prepare("SELECT * FROM pinjaman WHERE id = ?");
$stmt->execute([$id]);
$pinjaman = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$pinjaman) {
    die('Data pinjaman tidak ditemukan');
}

/* ===============================
   SETUJUI PINJAMAN
================================ */
if ($aksi === 'setujui') {

    // Update status
    $stmt = $db->prepare("
        UPDATE pinjaman 
        SET status = 'disetujui',
            tanggal_persetujuan = NOW(),
            sisa = jumlah
        WHERE id = ?
    ");
    $stmt->execute([$id]);

    // Kas keluar
    $stmtKas = $db->prepare("
        INSERT INTO kas (tanggal, masuk, keluar, keterangan)
        VALUES (NOW(), 0, ?, ?)
    ");

    $ket = "Pencairan pinjaman ID: $id";
    $stmtKas->execute([$pinjaman['jumlah'], $ket]);

    header('Location: ../modules/pinjaman/verifikasi.php');
    exit;
}

/* ===============================
   TOLAK PINJAMAN
================================ */
if ($aksi === 'tolak') {

    $stmt = $db->prepare("
        UPDATE pinjaman 
        SET status = 'ditolak'
        WHERE id = ?
    ");
    $stmt->execute([$id]);

    header('Location: ../modules/pinjaman/verifikasi.php');
    exit;
}

/* ===============================
   BAYAR ANGSURAN
================================ */
if ($aksi === 'bayar') {

    $jumlah = $_POST['jumlah'] ?? 0;
    if ($jumlah <= 0) {
        die('Jumlah tidak valid');
    }

    // Kurangi sisa
    $sisaBaru = $pinjaman['sisa'] - $jumlah;
    if ($sisaBaru < 0) $sisaBaru = 0;

    $stmt = $db->prepare("
        UPDATE pinjaman 
        SET sisa = ?
        WHERE id = ?
    ");
    $stmt->execute([$sisaBaru, $id]);

    // Catat angsuran
    $stmtAngsur = $db->prepare("
        INSERT INTO angsuran 
        (pinjaman_id, tanggal, jumlah)
        VALUES (?, NOW(), ?)
    ");
    $stmtAngsur->execute([$id, $jumlah]);

    // Kas masuk
    $stmtKas = $db->prepare("
        INSERT INTO kas (tanggal, masuk, keluar, keterangan)
        VALUES (NOW(), ?, 0, ?)
    ");

    $ket = "Angsuran pinjaman ID: $id";
    $stmtKas->execute([$jumlah, $ket]);

    header('Location: ../modules/pinjaman/angsuran.php');
    exit;
}

die('Aksi tidak dikenali');
